;
;	DMPDeHex:	De-hexifies an RSX-11 or P/OS DUMP/LONGWORD listing
;
;	File to display is entered on the command line; if no command line
;	is given, program gives a brief syntax message and exits.  If an error
;	occurs the program exits quietly. 
;
;	Can redirect output to MORE, a file, etc.
;
;	Derived from R50PC V1.01 03-Oct-1997 18:13
;	       and F11Read V2.00 25-Oct-1997 21:43

;	DmpDeHex Version History:
;
;	V0.00	14-Oct-1997		Started True Basic version
;	V0.50	21-Oct-1997 14:14	Final T.B. version (slow but works)
;	V1.00	27-Oct-1997 03:10	working assembler longword version
;	V1.01	29-Nov-1997 18:44	print CRLF after DMP's errors
;	

;	By Nicholas Zymaris, Kew Gardens, NY
;	e-mail:	nickz@idt.net
;
;	Written for A86 assembler.
;

	.radix	8

	org	100h

start:	jmp	begin

crlf:	db	15,12,"$"
tab:	db	11,"$"
buf6:	db	"XXXXXX$"
blkmsg:	db	15,12,"Block $"

fname:  db      "Q:\QQQ\QQQ\QQQ\QQQQQQQQ.QQQ",0         ; ASCIZ filename
outfil:	db      "Q:\QQQ\QQQ\QQQ\QQQQQQQQ.QQQ",0         ; ASCIZ filename

buff:	db	40,40,40				; use AH=2 not 9 for $
	db	40,40,40,40,40,40,".",40,40,40,0,0
bytbuf:	db	2
linbuf:	org	$+377
linmax	equ	$-linbuf
	db	"$"		; so it can easily be printed if needed

off_tbl:			; Offsets of each byte in line
	db	41,37,35,33, 30,26,24,22, 17,15,13,11, 6,4,2,0	; DUMP/LONG
;	db	55,52,47,44, 41,36,33,30, 25,22,17,14, 11,6,3,0	; DUMP/HEX
inlen  equ     29h             ; Length of input line in DUMP file
;inlen   equ     35h

sp2:	db	40,40,"$"				; 3 chrs + 2 in btwn

r50txt:	org	$+1000+2	 ; Extra buffer space
				 ; zero WORD terminates it
	dw	0
outbuf:	org	$+1000		; Output buffer

hlpmsg:	db	"DmpDeHex V1.01 - Assembler version, uses Longword, not Byte, dumps!"
	db	15,12,"Syntax: DmpDeHex [/switch] infile outfile",15,12,12
	db	"Switches:      (case insensitive)",15,12
	db	"(None for now)",15,12,"$"

;switch:	db	0		; Cmd line switches
;s_all	equ	1		; Display all blocks whether or not valid
;s_block	equ	2		; Display VBNs of index or image file
;s_full	equ	4		; Display full listing
;s_type	equ	8		; Type/display file by file ID

	even

handle:	 dw	0		; File handle (input file)
outhndl: dw	0		; File handle (output file)

f_blk:	dw	0		; Block of input file

begin:	mov	ax,cs		; Make sure segment regs have known values
	mov	ds,ax
	mov	es,ax

	mov	cl,[80h]	; Command line entered?
	or	cl,cl		;   (CL=#chars in cmd line; zero if none)
	jnz	get_fn		; Yes, get filename from it
	mov	dx,hlpmsg	; No command line: give help message
	call	print
	jmp	quit

get_fn:	mov	si,081h		; Point at first character of cmd line
	mov	di,fname
	xor	ch,ch

f_xfr:	cmp	b[si],"/"
	jne	no_sw
;	inc	si
;	dec	cx
;	cmp	b[si],"a"
;	jne	sw1
;	or	b[switch],s_all
;sw1:	cmp	b[si],"A"
;	jne	sw2
;	or	b[switch],s_all
;sw2:	cmp	b[si],"b"
;	jne	sw3
;	or	b[switch],s_block
;sw3:	cmp	b[si],"B"
;	jne	sw4
;	or	b[switch],s_block
;sw4:	cmp	b[si],"f"
;	jne	sw5
;	or	b[switch],s_full
;sw5:	cmp	b[si],"F"
;	jne	sw6
;	or	b[switch],s_full
;sw6:;	cmp	b[si],"t"
;	jne	sw7
;	jmp	sw7a
;sw7:	cmp	b[si],"T"
;	jne	sw8
;sw7a:	or	b[switch],s_type
;	add	si,2
;	sub	cx,2
;	call	getfid
;sw7q:	inc	si		;
;	dec	cx		;\  to be removed when actual getfid code
;	cmp	b[si]," "	;/  takes care of it
;	jne	sw7q		;
;
sw8:	inc	si
	dec	cx
no_sw:	cmp	b[si],"|"	
	jz	f_open
	cmp	b[si],"<"
	jz	f_open
	cmp	b[si],">"
	jz	f_open
	cmp	b[si]," "
	jne	f_ok
	inc	si
	dec	cx
	jz	f_open
	jmp	f_xfr

f_ok:	movsb
	dec	cx
	jne	f_ok2
	mov	dx,nofmsg
	call	print
	jmp	quit
nofmsg:	db	15,12,"No output file name provided$"
f_ok2:	cmp	b[si]," "
	jne	f_xfr

	dec	cx
	inc	si
	mov	b[di],0		; Make input filename ASCIZ
	mov	di,outfil
o_ok:	movsb
	cmp	b[si]," "
	je	open_out
	cmp	b[si],"<"
	je	open_out
	cmp	b[si],">"
	je	open_out
	cmp	b[si],"|"
	je	open_out
	dec	cx
	jnz	o_ok
		
open_out:
	call	openout

f_open:	mov     al,0            ; readonly, compatibility mode (R. Brown list)
        mov     dx,fname        ; Tell DOS the filename
        mov     ah,03dh         ; open file
        int     21h
	jnc	f_op1
	mov	dx,opmsg
	call	print
	jmp	quit		; otherwise might hang if odd input
opmsg:	db	15,12,"Can't open input file.$"

f_op1:	mov	[handle],ax	; save file handle

	mov	w[f_blk],-1	; Initialize it

f_read:
	call	getline

f_rd1a:
				; CX has string length from GETLINE
	cmp	cx,0		; Blank line (or <CR>, <LF> or <FF>)?
	jz	f_read		;  Yes, skip it
	mov	si,linbuf
	cmp	b[si]," "	; Space?
	je	f_read		;  Yes, skip it
	cmp	b[si],"D"
	jne	not_d
	cmp	b[si+1],"u"	; "Dump of..."?
	je	f_read		;  Yes, skip it
	jmp	valid_h		;  No, it's a valid hex string
not_d:	cmp	b[si],"*"	; "*" means either done (EOF) or parity error
	jne	not_star
	cmp	w[si+4],"OE"	; EOF? (on virtual block dumps only)
	jne	ne1
	mov	b[si+13],"$"	; So no garbage printed
	jmp	ne2
ne1:	mov	b[si+44],"$"	; Parity error (or any similar DMP msg)
ne2:	mov	dx,crlf		; [11/29/97] - so msg not on previous line
	call	print
	mov	dx,linbuf
	call	print		; Print DUMP's message
	mov	al,7
	int	29h		; And beep for good measure
	jmp	f_read
not_star:
	cmp	b[si],"0"
	jb	f_read
	cmp	b[si],"F"
	ja	f_read		; Reject < "0" and > "F"
	cmp	b[si],"9"
	jbe	valid_h
	cmp	b[si],"A"	; Accept any valid hex digit
	jae	valid_h
	jmp	f_read		; Skip everything else (e.g. <TAB>)

valid_h:
	inc	w[f_blk]	; Block number for display

	mov	dx,blkmsg
	call	print		; Print "Block "

	push	si
	mov	si,f_blk
	call	oct6		; Print octal block number (starting with 0)
	pop	si

	mov	ch,40		; No. of lines to read (octal)

vh_cnt:	xor	bx,bx		; Index to offset table
	xor	ax,ax
	mov	di,outbuf
	cmp	cl,inlen	; Each input line should be exactly this long
	je	v_cont
l_err:	mov	dx,linlenm	;
	call	print		; for debugging, but can't hurt if left in.
	jmp	quit		;
linlenm:			;
	db	15,12,7,"Invalid line length of DUMP file -- file is corrupt$"

v_cont:	xor	ah,ah
	mov	al,b[off_tbl+bx]
	push	si		; SI -> beginning of line in DUMP file
	add	si,ax
	call	dehex		; [SI] = two hex digits; return DL=byte value

	mov	b[di],dl
	inc	di
	
	pop	si		; SI -> beginning of line in DUMP file
	inc	bx
	cmp	bx,0Fh
	jbe	v_cont

	dec	ch
	or	ch,ch
;	int 3
	jne	nxtlin
	call	writeit
	jmp	f_read		; Done reading block, go to next one

nxtlin:	push	cx
	call	getline
	cmp	cl,inlen	; Each input line should be exactly this long
	jne	l_err
	pop	cx
	mov	si,linbuf
	xor	bx,bx
	jmp	v_cont

;01008A21 44100000 00160000 01050000 	0000
;15 54 11 03 06 00 15 C4 0A 05 FF FE 00 E0 95 DF 	0010

;01008A21 44100000 00160000 01050000 	0000
;15541103 060015C4 0A05FFFE 00E095DF 	0010
;				   ^ linbuf[34d=42o]

dehex:	xor	ah,ah		; means 1st of two digits
	xor	dx,dx		; Initialize output register
dh_lp:	mov	al,b[si]	; 16's digit
	cmp	al,"0"
	jb	dh_fatal
	cmp	al,"F"		; Reject < "0" and > "F"
	ja	dh_fatal
	cmp	al,"9"
	jbe	d_valid
	cmp	al,"A"		; Accept any valid hex digit
	jae	d_valid2
	jmp	dh_fatal	; Anything else means corrupt DUMP file
d_valid2:
	 sub	al,"A"-"0"-0Ah
d_valid: sub	al,"0"
	or	ah,ah
	jne	d_ones
	shl	al,4
d_ones:	add	dl,al
	inc	si
	inc	ah
	cmp	ah,1
	jbe	dh_lp
	ret	

dh_fatal:
	mov	dx,dhfmsg	; Overwrites (invalid) hex value in DL
	call	print
	jmp	quit
dhfmsg:	db	15,12,7,"Invalid hex digit -- exiting.",15,12,"$"
;
;	More subroutines
;
openout:
	mov	b[di],0		; Make output filename ASCIZ
	mov	ax,4e00h	; Find First File
	xor	cx,cx		; File attributes - I'm not picky
	mov	dx,outfil
	int	21h
	jc	oo2
	mov	dx,fexmsg
	call	print
	jmp	quit
fexmsg:	db	15,12,"File already exists - exiting.$"
oo2:	cmp	ax,3		; Possible: 2 (FNF), 3 (Path not found),
	jne	oo3		; 12h (No more files)
	mov	dx,onpmsg
	call	print
	jmp	quit
onpmsg:	db	15,12,"Output file path not found.$"
oo3:	mov	ax,03c00h	; Create output file
	mov	cx,40		; 40 octal = set archive bit
	mov	dx,outfil
	int	21h		; possible errors: 5 (access denied),
	jnc	oo4		;  6 (invalid handle)
	mov	dx,oemsg
	call	print
	jmp	quit
oemsg:	db	15,12,"Can't open output file.$"
oo4:	mov	[outhndl],ax	; Save file handle
	ret

writeit:
	push	ax
	push	bx
	push	cx
	push	dx
	mov	dx,outbuf
	mov	ax,4000h	; Write to file
	mov	bx,[outhndl]
	mov	cx,1000		; Write one block
	int	21h
	jnc	w_ok
	mov	dx,werr
	call	print
	jmp	quit
werr:	db	15,12,"Error writing file - disk may be full.$"
w_ok:	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret

getone:	push	cx
	mov     ah,03fh         ; read file
	mov	bx,[handle]	; get file handle
        mov     cx,1         	; read a byte
        mov     dx,bytbuf	; Read into this buffer
        int     21h		; (Errors handled in getline)
	pop	cx		; Preserve total character count
	ret

getline:			; returns string in linbuf, length in CX
	xor	cx,cx		; Count of characters read
	mov	si,linbuf	; Point to first position in buffer
gl_lp:	cmp	cx,linmax
	jae	toomuch		; Not likely with DUMP files
	call	getone
        jnc	f_rd1

	mov	dx,rerr
	call	print
	jmp	quit
rerr:	db	15,12,"End of file?$"	
	jmp	quit            ; Error? (e.g. EOF)

f_rd1:	cmp	ax,0		; No msg if exiting this way
        jz	f_quit		; nothing read (covers EOF) -- quit
	cmp	ax,1
	je	gl_ok
	call	uhoh
	db	"Shouldn't get here - didn't get 1 character.",15,12,"$"
uhoh:	pop	dx
	call	print
	jmp	f_quit
gl_ok:	cmp	b[bytbuf],15	; Here if got one character
	jne	gl2		; not a <CR>
	call	getone		; It's a <CR>; eat the <LF>
	jc	quit
toomuch: ret
gl2:	cmp	b[bytbuf],12	; A <LF>?
	jne	gl3
	ret
gl3:	cmp	b[bytbuf],14	; A <FF>?
	jne	gl4
	ret
gl4:	mov	al,b[bytbuf]
	mov	b[si],al	; Else, save the character
	inc	si
	inc	cx
	jmp	gl_lp

f_quit:	pop	ax		; adjust stack
				; and quit...
quit:	push	ax 
	mov     ax,03e00h	; close files
	mov	bx,[outhndl]
	int	21h
	mov     ax,03e00h
	mov	bx,[handle]
	int	21h
	pop	ax
	mov	ah,04ch
	int     21h		; exit

	.radix	10		; because these routines assume that

print:	push	ax
	mov	ah,9
	int	21h
	pop	ax
	ret

; Z2S2 (Zeroes to	; Convert zeroes to spaces from [DX] to first
;	Spaces 2)	; nonzero character, putting spaces at end
			; (modified from COMTEST/NZTERM's Z2S)

z2s2:	push	bx
	push	cx
	push	dx
	push	bp
	mov	bx,dx
	mov	cx,bx
	mov	bp,bx
	add	cx,5	; Address of last character
z2s_1:	cmp	byte[bx],"0"	
	jne	z2_nz
	inc	bx
	cmp	bx,cx
	jne	z2s_1
z2_nz:	mov	dl,[bx]
	mov	[bp],dl

	inc	bx
	inc	bp
	cmp	bx,cx
	jbe	z2_nz
	mov	b[bp],"$"
	pop	bp
	pop	dx
	pop	cx
	pop	bx
	ret

oct6:	push	ax
	push	bx
	push	dx
	mov	ax,[si]
	mov	bx,buf6
	mov	w[bx],"  "
	mov	w[bx+2],"  "
	mov	w[bx+4],"  "
	call	octdmp
	mov	dx,buf6
	call	z2s2		; modify to remove zeroes
	mov	dx,buf6
	call	print
	pop	dx
	pop	bx
	pop	ax
	ret

octdmp:			; Dump an octal word in AX to BX
	.radix	8
	push	ax		; Save it
	push	bx

	push	ax		; Save AX for local use
	and	ax,100000
	shr	ax,7
	add	ah,"0"
	mov	b[bx],ah
	inc	bx

	pop	ax
	push	ax
	and	ax,70000
	shr	ax,4
	add	ah,"0"
	mov	b[bx],ah
	inc	bx

	pop	ax
	push	ax
	and	ax,7000
	shr	ax,1
	add	ah,"0"
	mov	b[bx],ah
	inc	bx

	pop	ax
	push	ax
	and	ax,700
	shl	ax,2
	add	ah,"0"
	mov	b[bx],ah
	inc	bx

	pop	ax
	push	ax
	and	ax,70
	shr	ax,3
	add	al,"0"
	mov	b[bx],al
	inc	bx

	pop	ax
	push	ax
	and	ax,7
	add	al,"0"
	mov	b[bx],al

	pop	ax		; Pop local copy
	pop	bx
	pop	ax
	ret

	.radix	10

fastout:
	;						  July 3, 1997
	; Input: BX = pointer to string terminated by "$"
	;
	; Trashes AX & BX
	;
	mov	al,byte ptr[bx]	; [V2.1] point to each character
	int	29h		; [V2.1] Fast Con. Output (can't be redirected)
	inc	bx		; [V2.1] Next character (trashes BX) 
	cmp	byte ptr[bx],"$"; [V2.1] Use usual string terminator
	jne	fastout		; [V2.1] 
	ret

; From header comments in True Basic version:

;(Note that for this program, one must DUMP/LONG not DUMP/HEX)

;rem Convert RSX-11 or P/OS DUMP /HEX listing to a file.
;rem Nicholas Zymaris 14-Oct-1997
;rem  Bugfix 21-Oct-1997: a block whose a$ starts with "D" could be a valid
;rem  hex string, not just "Dump of..."; also differentiate between EOF and
;rem  other message (bad parity) which one can find in logical block dumps.
;rem
;rem To dump a file: DUMP/HEX/OUT:XK: filename | bitcom >file.hex
;rem To dump a diskette: DUMP/BL:0:1437/HEX/OUT:XK: DZ1: | bitcom >file.hex
;rem To dump a hard drive or other device, substitute the proper octal
;rem block numbers and device name in the above line.  The | and > symbols
;rem are shorthand, of course; any terminal program can be used on the PC
;rem side to receive the ASCII file; don't type the "|" and subsequent
;rem characters on the DCL command line.  Diskettes must be mounted foreign
;rem before dumping, e.g. with r $qiolog <CR> NL: <CR> n <CR> Y <CR> ^C ^C
;rem (the "n" is the device number: DZ1: = 1, DZ2: = 2, DW1: = 3, other = 4;
;rem  if other, it needs to be specified).

	end	start
