;	P/OS V2.0 main menu, from MAINMENU.ANS (1882 bytes, 03-27-97 3:15p)
;	Also is first use of streamlined GETKEY routine.
;	N.Z. 2-Jan-2001
	.model	tiny
	.code
	.radix	10
main	proc
	org	100h
start:	mov	ax,cs		; Make sure segment regs have known values
	mov	ds,ax		; (maybe setup stack too if needed)
	mov	es,ax		; (and set device=-1 if to be reentrant)
	cld			; And that we're going forward in LODSB's etc.
	xor	bl,bl
	mov	dx,offset cls
	call	print
	mov	dx,offset menu0
	call	print
	mov	dx,offset bline
	call	print
	mov	dx,offset arrow
	call	print

	mov	dx,offset prefix
	call	print
	mov	dx,offset tk
	call	print

	mov	dx,offset prefix
	call	print
	mov	dx,offset bas
	call	print

	mov	dx,offset prefix
	call	print
	mov	dx,offset dutl
	call	print

	mov	dx,offset prefix
	call	print
	mov	dx,offset futl
	call	print

	mov	dx,offset prefix
	call	print
	mov	dx,offset putl
	call	print

	mov	dx,offset prefix
	call	print
	mov	dx,offset adapl
	call	print

	mov	dx,offset prefix
	call	print
	mov	dx,offset vutl
	call	print

	mov	cx,6
bl2:	  mov	dx,offset bline
	  call	print
	loop	bl2
	mov	dx,offset bline2
	call	print
	mov	dx,offset bmenu
	call	print

	mov	dx,offset do
	call	print
	mov	dx,offset compl
	call	print
	mov	dx,offset empty
	call	print
	mov	dx,offset bot
	call	print

L1:	call	getkey		; L1: get key; if key="" then L1
	cmp	ah,0		; Extended character?
	jne	extchr		; Yes
	cmp	al," "		; Spacebar pressed? (emulating EXIT key)
	je	done0		; If so, exit.
	cmp	al,0Dh		; <CR>? (emulating DO key)
	je	select		; yes, select the menu option
	jmp	L1		; Any other non-ext key, ignore and get another

extchr:	cmp	ah,"H"		; move arrow up if up arrow pressed;
	jne	L2
	test	bl,bl		; arrow position must be 0 (.ge.)
	jz	beep
	dec	bl
	mov	dx,offset arerase
	call	print
	mov	dx,offset up
	call	print
	mov	dx,offset newar
	call	print
	mov	dx,offset bot
	call	print

L2:	cmp	ah,"P"		; move arrow down if down-arrow pressed;
	jne	L3
	cmp	bl,6
	ja	beep		; arrow position must be 6 (.le.)
	inc	bl
	mov	dx,offset arerase
	call	print
	mov	dx,offset down
	call	print
	mov	dx,offset newar
	call	print
	mov	dx,offset bot
	call	print

L3:	cmp	ah,";"		; F1, emulating HELP key
	jne	L4
	call	mfram
	mov	dx,offset hlpmsg
	call	print
	mov	dx,offset cntmsg
	call	print
	jmp	restrt
L4:	cmp	ah,"D"		; F10, emulating EXIT key
done0:	je	done
;L5:	; other extended keys go here

;int 29h	; quickie diagnostic to display key codes
;xchg ah,al
;int 29h
	jmp	L1		; No, keep going
select:	test	bl,bl
	jz	beep		; can't select if nothing selected
	call	mfram
	mov	byte ptr[selno],bl
	add	byte ptr[selno],48d
	mov	dx,offset selmsg
	call	print
	mov	dx,offset cntmsg
	call	print
restrt:	call	getkey		; restart
	jmp	start

beep:	mov	al,7		; Ctrl-G = beep
	int	29h		; fastout, not redirected
	jmp	L1

done:	mov	dx,offset bot
	call	print
	mov	dx,offset up
	call	print
	mov	ax,04c00h	; Exit with errorlevel 0 (success)
	int	21h

print:	;push	ax
	mov	ah,9
	int	21h
	;pop	ax
	ret

; Streamlined GETKEY, N. Zymaris 2-Jan-2001
; AX & DX are not preserved; returns AH=0 if non-extended key and AL=0 if
; extended key pressed; the other half of AX will contain the key code.
getkey:	mov	ah,6		; Direct Console Input (from stdin)
	mov	dl,0ffh		; "
	int	21h		; Key pressed?
	jz	getkey		; ZF=0 if no key pressed; just continue
	cmp	al,0		; Extended code?
	jne	noext
	push	ax		; save first character
	int	21h		; get second part of extended character
	pop	dx		; first char in DL now
	xchg	ah,al		; and second char in AH
	mov	al,dl		; first char in AL for return
	jmp	gret		; return with DX clobbered
noext:	xor	ah,ah		; indicate no extended key
gret:	ret			; return key pressed in AH (if extended),AL

mfram:	mov	dx,offset cls
	call	print
	mov	dx,offset bmenu+2
	call	print
	mov	cx,19d
mf1:	  mov	dx,offset bline2
	  call	print
	loop	mf1
	mov	dx,offset bmenu
	call	print
	mov	dx,offset mtop
	call	print
	ret

	.radix	8
cls	db	33,"[H",33,"[J$"
menu0	db	33,"[7m                            "
	db	"MAIN MENU - P/OS V2.0A                             ",33,"[m"
	db	15,12,"                          "
	db	"                                                 "
	db	15,12,"          "
	db	"Copyright  1984 Digital Equipment Corporation"
	db	"                   "
	db	15,12,"          "
	db	"For information on using the Professional, press HELP."
	db	"           $"
bline	db	15,12,"                                      "
	db	"                                     $"
arrow	db	15,12,"                    ",33,"[s->                "
	db	"                                     $"
prefix	db	15,12,"                          $"
tk	db	33,"[1mTool Kit V2.0",33
	db	"[m                                    $"
bas	db	33,"[1mBASIC V1.2",33
	db	"[m                                       $"
dutl	db	33,"[1mDisk",33,"[m/diskette services"
	db	"                           $"
futl	db	33,"[1mFile",33,"[m services"
	db	"                                    $"
putl	db	33,"[1mPrint",33,"[m services"
	db	"                                   $"
adapl	db	33,"[1mAdd",33,"[mitional applications"
	db	"                          $"
vutl	db	33,"[1mView",33,"[m Message/Status"
	db	"                              $"
bline2	db	15,12,33,"[7m  ",33,"[m                                     "
	db	"                                      ",33,"[7m  ",33,"[m$"
bmenu	db	15,12,33,"[7m                                               "
	db	"                                ",33,"[m$"
do	db	15,12,"    Make a choice and press DO:$"
; [8mWidth & height of menu reduced by 1 so Zenith display doesn't wrap[m
; (height restored for this executable version)
compl	db	15,12,"    Application completed successfully.$"
empty	db	15,12,"    The message board is empty.$" ;,33,"[A$"
arerase	db	33,"[u  ",33,"[2D$"
up	db	33,"[A$"
down	db	33,"[B$"
newar	db	33,"[s->$"
mtop	db	33,"[4;5H$"
bot	db	33,"[25;4H$"
selmsg	db	33,"[5mSelected option "
selno	db	"X",33,"[m$"
hlpmsg	db	"Very simple emulator of P/OS V2.0 menu system, "
	db	"by Nicholas Zymaris."
	db	15,12,33,"[4CVersion 1.00, 2-Jan-2001."
	db	15,12,12,33,"[7C"
	db	"Use up & down arrow to move arrow; <CR> to select."
	db	15,12,33,"[7CF1 is HELP, SPACE or F10 is EXIT."
	db	15,12,33,"[7COther keys ignored for now.$"
cntmsg	db	15,12,12,33,"[m",33,"[7CPress any key to continue. $"
	endp	main
	end     start
